-- Guidelines for BookDocumentTable:
-- containerId: id of the container item (bookcase, shelf, corpse, etc). Optional.
-- itemId: id of item (book, scroll, letter, etc).
-- position: position of the container or of the item (depending on if the item is on a container or not).
-- text: text of item (book, scroll, letter, etc).
BookDocumentTable = {
	[1] = {
		containerId = 2435,
		itemId = 2828,
		position = {x = 32063, y = 31884, z = 4},
		text = [[
MONSTERS AND FOES OF DAWNPORT I

Intelligent monsters

The troll - Though intelligent in a limited way, usually trolls do not pose a major threat to our outpost, though they are scouting the outskirts of our grounds and attack passersby. They are able to create and use some basic equipment, and are tough to lesser weapons and unskilled fighters.

The orc - The green-skinned orc is intelligent and able to use weapons and armor. They are warriors of some power and very dangerous in greater numbers. Luckily enough, there are not many of their more skilled fighters around, like the berserker or warrior. Still, a handful of them is enough to get an adventurer into dire straits.

The goblin - sneaky and devious, goblins steal everything that is not nailed down. Though small and relatively easy to fight, they don't shirk from attacking humans when they feel superior in numbers. They normally stay in their hideouts underground, where they hoard their loot.

The minotaur - a dreaded beast and fearsome fighter, the minotaur is a formidable foe for a young adventurer. Particular caution should be exercised when going to their lair underground, as they have some skilled archers and even some mages that may kill you very, very quickly.

Other beasts - It is certain that other beasts live in the dungeons of our isle. But they are not numerous enough to be recognised yet. If you encounter any unknown beast it is certainly dangerous and a potential lethal enemy. Don't underestimate them.
		]]
	},
	[2] = {
		containerId = 2435,
		itemId = 2828,
		position = {x = 32063, y = 31884, z = 4},
		text = [[
MONSTERS AND FOES OF DAWNPORT II

Underground and undead beasts

The rotworm - A creature of decay that lives underground like its small cousin, the earthworm. Its toothed maw is a formidable weapon, and rotworms have torn more than one adventurer to pieces. A horde of them could kill anyone, so great caution is advised when encountering them.

The carrion worm - They seem to be no species of their own but indeed just older, bigger and meaner rotworms. They are usually accompanied by a host of smaller worms which makes them even more dangerous. Carrion worms have some sort of tusks that can easily penetrate a good armor.

The skeletons - Skeletons are living undead, rumoured to be the bodies of dead adventurers which have been revived by some evil power. Cropping up in packs and occasionally accompanied by other undead creatures like ghouls or mummies, they are quite nasty opponents, particularly because they are able to drain the life energy of their opponents.

The bat - Often encountered in caves and ruins, along with other creatures, sometimes undead. Being little stronger than a rat, bats are rather a nuisance than a threat to an experienced adventurer. Their attacks on humans mainly happen out of self-defence. Bats often form a large swarm which is slightly more dangerous to face than a single specimen. Bats can be found almost everywhere as long as there is some close-by dark place where they can breed and sleep.

The rat - Whether humans brought this pest with them on the isle or whether rats are indigenous to every dark place in Tibia is anyone's guess. However, rats on Dawnport normally prefer to live underground and are mostly harmless, tending to destroy food supplies in cellars. They can become dangerous in greater numbers, though, to any badly equipped adventurer they corner.
		]]
	},
	[3] = {
		containerId = 2435,
		itemId = 2828,
		position = {x = 32063, y = 31884, z = 4},
		text = [[
MONSTERS AND FOES OF DAWNPORT III

Poisonous beasts

The salamander - A common creature of the swamp and warm earth of the marshes, the salamander relies on stealth and a little poison to ward off attackers. Normally living on a diet of insects, it seems that here on Dawnport some salamanders have developed a taste for the rare dawnfire herb. Those salamanders have often been sighted in the company of trolls and it is supposed that the trolls keep them as a sort of pet, though to what reason, nobody knows yet. Though relatively harmless, the poison of the troll-trained salamanders is not to be underestimated and can seriously injure or kill inexperienced adventurers.

The wasp - fast and deadly to the inexperienced, wasps will follow their enemy for quite a while, and their speed makes them dangerous, even more so in high numbers. Their sting hurts and can poison you, so make sure to finish a wasp off quickly when you encounter it. They can be found in warm areas such as woodlands, jungles or deserts; and if there is a heat source, in underground stone caves.

The poison spider - Though only slightly tougher than an ordinary spider, this one can poison you. Try to avoid being bitten by one, as they usually live far from our base and you might not make it to our local healer in time.
		]]
	},
	[4] = {
		containerId = 2436,
		itemId = 2828,
		position = {x = 32064, y = 31884, z = 4},
		text = [[
MONSTERS AND FOES OF DAWNPORT IV

Creatures of the meadows and marshes

The dawnfly - A close relative of the emerald damselfly found in the swamps of Venore, it is supposed the creature may have found its way over the seas to Dawnport and adapted to the isle. Like the damselfly, their diet consists of plant matter and smaller insects though they too attack passersby, supposedly to guard their territory. Their bite is slightly poisonous, but poses a threat only to the wounded or completely unprepared wanderer.

The woodling - The woodlings could be the missing link between the swamplings and the haunted treelings. Half plant and half animal and at least partially intelligent, treelings love to ambush their prey and make use of the surroundings to drive it into a corner. Looking deceptively tree-like, a woodling will make a grab at any human that passes; supposedly to spice up its diet of rotting leaves and plants with something more juicy. Woodlings can slow down their enemies and are quite tough, which is why any inexperienced adventurer would do well to know the way back to the outpost in a hurry if venturing down to the woody plains.

The Meadow strider - A giant bird that stalks the marshes and meadows, the meadow strider usually feeds on small insects and amphibians. Being very territorial but short-sighted, it will attack any supposed rival of its own size, which includes humans, and peck at them. Though they are nearly as tough as woodlings, there's good eating on a meadow strider, and they often contain swallowed gold coins and other useful stuff.
		]]
	},
	[5] = {
		containerId = 2436,
		itemId = 2828,
		position = {x = 32064, y = 31884, z = 4},
		text = [[
MONSTERS AND FOES OF DAWNPORT V

Creatures of the woods

The wolf - There are some loner wolves roaming this isle. Wolves are fast, tough and dangerous. Often they are the hunters and not the hunted. It is a good decision to engage them in combat only with decent equipment and to fight a wolf one on one. If there's nothing else, you can always eat a hunch of wolf, and sell its fur.

The bear - Bears are hard to beat! Keep that in mind before challenging one. If you are inexperienced and don't have good equipment, retreat is the tactic of choice. Best kill bears in small hunting parties and use terrain to your advantage.

The deer - Deers are a fine supply for food and are non-agressive animals and try to flee on sight. It might be difficult to catch them and you might easily enter the territory of a local predator while chasing them.

The hare - Like deers, hares will flee upon sight and are an excellent source of food for any passing adventurer. They are a common sight in the meadows and forests of Tibia, though larger predators are never very far.

The squirrel - Swift and impish, squirrels will run from any human they see. Hunters avoid preying on squirrels, as there is a legend that says that the giant immortal Squirrels who ate nuts from Crunor's blessed tree take bloody revenge on each and every killer of their descendants. Squirrels are found in woody areas all over Tibia.
]]
	},
	--The isle of the kings (need position)
	[6] = {
		containerId = 2437,
		itemId = 2821,
		--position = {x = xxxxx, y = xxxxx, z = x},
		text = [[
Kazordoon, the hidden city
In the blocklike Mountain, known as the big old one, the hidden city of kazordoon is nestled. Its the last refuge of the ancient race of dwarves. Hidden and heavily fortified it was the last stand of dwarvenhood in the wars of creation and the last hope of that race to adapt to and survive the new ages. The famous giant statue, known as colossus guards its entry, alhough the narrow valley makes it difficult to see that fortress-statue and admire its beauty. Kazordoon is known for its safety and masterful smithery throughout the lands.
Since some generations the dwarven city (whose ruler claims a title that might be translated as 'emperor') is allied with the thaian kingdom.
]]
	},
	[7] = {
		containerId = 2437,
		itemId = 2825,
		position = {x = 32065, y = 31884, z = 4},
		text = [[
Kazordoon, the hidden city
In the blocklike Mountain, known as the big old one, the hidden city of kazordoon is nestled. Its the last refuge of the ancient race of dwarves. Hidden and heavily fortified it was the last stand of dwarvenhood in the wars of creation and the last hope of that race to adapt to and survive the new ages. The famous giant statue, known as colossus guards its entry, alhough the narrow valley makes it difficult to see that fortress-statue and admire its beauty. Kazordoon is known for its safety and masterful smithery throughout the lands.
Since some generations the dwarven city (whose ruler claims a title that might be translated as 'emperor') is allied with the thaian kingdom.
		]]
	},
	[8] = {
		containerId = 2437,
		itemId = 2831,
		position = {x = 32066, y = 31884, z = 4},
		text = [[
Genesis I. The Awakening of the Gods

In the beginning there was only a big, gaping void. It was everywhere and nowhere.

In this emptiness two powerful entities appeared who were eventually known as the elder gods: Fardos the Creator and Uman Zathroth who combined in himself two unequal halves. One of these halves was Uman the Wise, a benign god who was gifted with divine intellect, while Zathroth the Destroyer was the other, darker half. These were the two halves of one single enigmatical entity, and even though either of them was perfectly capable of acting on his own just as if he had been fully independent, independent they were not. They were bound together by an eternal bond that could not be broken, and their destiny was one.

Nobody knows where the elder gods came from, or whether they had always existed and eventually awoke from the slumber of infinity. But somewhere along the way they decided to create a universe. Surely Fardos was the initiator, for he was driven by the need to create and give life. He was overflowing with creative power and impatient to release it, so he stepped into existence and began to unleash his powers. However, none of his attempts to create were successful. All of his creations were swallowed by the void before they were completed, and none survived.

Uman Zathroth regarded Fardos's undertakings thoughtfully. Uman was sagacious and held awesome magical powers. Most importantly, however, he was driven by an insatiable hunger for knowledge and enlightenment. In his essence he resembled Fardos, but where Fardos worked openly and logically, Uman's domain was the realm of mystery. Still, he shared Fardos's interest in creation, whereas his dark half Zathroth was essentially corruptive. Zathroth was a vain god who was painfully aware that his own creative powers were poor. Because of this he looked at Fardos's work of creation with jealousy, and from the very beginning he was determined to prevent or at least corrupt it in any way he could. Fardos, who did not suspect this, asked him for assistance because he had accepted the fact that he could not achieve creation on his own, but of course Zathroth denied. Uman, however, agreed to help. And from that he and Fardos worked together on the great project that was creation.


Unfortunately, their combined efforts were hardly more successful. Just like before, everything Fardos and Uman created was swallowed by the void as soon as it came into existence, and the two gods sadly saw their creation run through their fingers like water through a sieve. On the other hand, Zathroth, who had been watching their efforts with suspicion, rejoiced. He ridiculed their efforts. However, his glee changed into surprise and anger when he found that something strange happened, something which perhaps Uman and Fardos did not expect themselves. To this day, nobody knows precisely what it was that caused it. Perhaps the power that had been spent lured another entity out of the void, or it might be that it simply awoke another divine entity from its slumber. Some even claim that in some mysterious way the power that had been spent by Uman and Fardos actually created a new entity. Whatever the truth may be, a new goddess stepped out of the void like a new-born mermaid from her shell. The amazed elder gods watched her divine beauty in awed admiration, for everything in her was perfect harmony. They agreed to call her Tibiasula. Zathroth, however, stood by and fumed with silent hate. But cunning as he was, he hid his resentment well and feigned to share the joy of the other elder gods.
		]]
	},
	[9] = {
		containerId = 2437,
		itemId = 2831,
		position = {x = 32066, y = 31884, z = 4},
		text = [[
Genesis IV. The First Creatures

Zathroth watched the progress of creation with wrath and disgust. If he had had his way, he would have obliterated creation then and there. However, he knew that he lacked the power to do that, especially since Fardos and Uman were now well aware of his intentions and watched him carefully. He would have to resort to other means to bring ruin to creation. It was for this reason that he watched the concept of life with great interest, because he foresaw quite clearly that a lot of mischief could be done with it. Much as he loathed most of the gods that had been created, there was one who had caught his attention. Fafnar's base instincts and her destructive powers did not fail to impress him, and so a plan came to his mind. He flattered her with compliments and before long he succeeded in seducing her. Thus Brog the Raging Titan was conceived. An exceedingly ugly abomination that had only one eye in its huge head, Brog had inherited little of his father's cunning and none of his caution, yet he was strong and fierce, and his mother's furious heat burned wildly inside him.

As he grew up, Brog was pained by the fire burning inside him, until one day when it grew unbearable he summoned all his magical powers and released as much of the painful flame into the world as he could. The searing fire mixed with his rage, and from it rose Garsharak, the very first dragon, who later sired a whole race of intelligent, giant lizards, a race that would eventually bring terror and chaos into Tibia. Brog watched the terrible creature he had created rather accidentally, and he rejoiced when he saw just how fierce and powerful it was. Though he was rather stupid he, too, had the gift to create life, which in an act of vanity he next used to create the cyclopes in his own image.


Zathroth watched Brog's experiments with great interest. So far he had not held his son in high esteem, but here was something for which he himself admittedly had little talent for. Since he did not understand the laws of life himself he knew that Brog's gift could prove to be a great asset. He called his son to him and told him to go on with his experiments, urging him to create something more terrifying and destructive than cyclopes. Even though these giants were ferocious and strong, they were not quite as destructive as he wanted them to be. In fact, due to their love of mining and smithing the cyclopes were a creative rather than a destructive race. Worse, they were not propagating fast enough to make them a real threat to creation. For this reason Brog went on to create trolls and goblins, races that were weaker than the cyclopes, but propagated much faster. However, his undisputed masterpiece were the orcs, a race of fearsome, single-minded warriors who lived only to expand and conquer. Soon they had spread all over Tibia, and they were the scourge of all that was alive.
		]]
	},
	[10] = {
		containerId = 2435,
		itemId = 2821,
		--position = (isle of the kings),
		text = [[
The Minotaurs by Iregarn Pt. 1
The minotaurs claimed that they were once the marshals and favoured people of Blog, the raging one. In the wars over creation they were one of the most successful races. But as the war grew more and more fierce it were the wild and raging minotaurs that had to pay the worst blood toll. The berserker rage inherent to their race made them a formidable opponent but also very vulnerable.
Though victorious in most battles, in the end the berserking warriors had to surrender to their wounds or were left crippled and executed and fed to Blogs lesser followers. Even worse, the raging minotaurs knew neither friend nor enemy. Brother slew brother, fathers slaughtered their sons in their rage. Then, one day a minotaur, named Tha'kull conquered his rage. He withdrew from battle and became a hermit. In his travels he met Akkor, the blind one. This minotaur was by fate not subjected to the rage inherent to the minotauren race and had aquired a tranquility and wisdom, unknown to his kind so far. Tha'Kull thaught the blind one how to improve his body and fortitude and Akkor in return teached the warrior how to improve his soul.
He looked upon the world and for the first time in aeons a minotaurean warrior saw the world without hatred. He saw the beauty in things, simple and complex. He saw the harmony in creation and the place the living had in it. He also saw the place that was meant to be taken by the sentient beings among the living. And he went back to his people to teach. Never a warrior of the minotaurs had neglected his rage and even though he was cautious the angry berserker warlords would not allow the words he spoke to be heard by their people.
]]
	},
	[11] = {
		containerId = 2435,
		itemId = 2825,
		position = {x = 32061, y = 31889, z = 4},
		text = [[
The Minotaurs by Iregarn Pt. 1
The minotaurs claimed that they were once the marshals and favoured people of Blog, the raging one. In the wars over creation they were one of the most successful races. But as the war grew more and more fierce it were the wild and raging minotaurs that had to pay the worst blood toll. The berserker rage inherent to their race made them a formidable opponent but also very vulnerable.
Though victorious in most battles, in the end the berserking warriors had to surrender to their wounds or were left crippled and executed and fed to Blogs lesser followers. Even worse, the raging minotaurs knew neither friend nor enemy. Brother slew brother, fathers slaughtered their sons in their rage. Then, one day a minotaur, named Tha'kull conquered his rage. He withdrew from battle and became a hermit. In his travels he met Akkor, the blind one. This minotaur was by fate not subjected to the rage inherent to the minotauren race and had aquired a tranquility and wisdom, unknown to his kind so far. Tha'Kull thaught the blind one how to improve his body and fortitude and Akkor in return teached the warrior how to improve his soul.
He looked upon the world and for the first time in aeons a minotaurean warrior saw the world without hatred. He saw the beauty in things, simple and complex. He saw the harmony in creation and the place the living had in it. He also saw the place that was meant to be taken by the sentient beings among the living. And he went back to his people to teach. Never a warrior of the minotaurs had neglected his rage and even though he was cautious the angry berserker warlords would not allow the words he spoke to be heard by their people.
]]
	},
	[12] = {
		containerId = 2437,
		itemId = 2816,
		--position = (Rookgaard Academy),
		text = [[
Orcs ARE intelligent. Though some dwarves mumble about a shared hivemind of the greenskins, there is no evidence for that. Orcs have speech and are capable to learn other humanoids language quite well ... if they want, what almost never is the case. They lack a written language though. Some of the more educated orcs use human letters to write down orcish texts. Its rumored that the orcs we encounter now and then are just barbarians of their own kind and that there is a more 'civilized' orcish culture somewhere. There are some clues that the orcs indeed had a written language, but the modern orcs is unable to read it as we are.
]]
	},
	[13] = {
		containerId = 2437,
		itemId = 2847,
		position = {x = 32062, y = 31889, z = 4},
		text = [[
Orcs ARE intelligent. Though some dwarves mumble about a shared hivemind of the greenskins, there is no evidence for that. Orcs have speech and are capable to learn other humanoids language quite well ... if they want, what almost never is the case. They lack a written language though. Some of the more educated orcs use human letters to write down orcish texts. Its rumored that the orcs we encounter now and then are just barbarians of their own kind and that there is a more 'civilized' orcish culture somewhere. There are some clues that the orcs indeed had a written language, but the modern orcs is unable to read it as we are.
		]]
	},
	[14] = {
		containerId = 2435,
		itemId = 2830,
		position = {x = 32068, y = 31889, z = 4},
		text = [[
There are two kinds of spells: rune spells and spontaneous spells. Rune spells are cast on blank rune stones, which requires mana. Rune stones can easily be carried around and store the specific spell. It can be used at any time, and only some spells require further investment of mana.
Spontaneous spells are cast in the heartbeat they are needed, and take effect instantly. Most of these are healing spells, but there are also aggressive spells, invisibility or shape change spells, and more.
]]
	},
	[15] = {
		containerId = 2435,
		itemId = 2816,
	   --position = (Rookgaard Libraries),
		text = [[
Magic

There are two kinds of spells: rune spells, and instant spells. Rune spells are cast on blank runes and some mana is used up in this process.

These can easily be carried around and store the specific spell. It can be used at any time, and only some require further investment of mana.

Instant spells are cast in the heartbeat they are needed and take effect instantly. Some of these spells Instant Spells heal while others are agressive and some even have more astonishing effects, such as invisibility.
		]]
	},
	[16] = {
		containerId = 2435,
		itemId = 2821,
		--position = (Isle of the Kings Library),
		text = [[
Magic by Puffels
There are two kinds of spells: rune-spells, and spontaneous spells.
Rune-spells are cast on blank runestones and some mana is used up in this proces. This stones can easily be carried around and store the specific spell. It can be used at any time, and only some require further investment of mana.
Spontaneous spells are cased in the heartbeat they are needed and take effect instantly. Most of these spells are spells of healing but some of them are agressive and some even have more astonishing effectes, as invisibility, illusionary shapechange etc.
]]
	},
	[17] = {
		containerId = 2436,
		itemId = 2821,
		position = {x = 32069, y = 31889, z = 4},
		text = [[
Combat Tactics

Most monsters are far more dangerous when you're attacked by more of them. Keep in mind that no more than two enemy attacks can be blocked at a time. Use this to your advantage and attack single monsters with help of other heroes. Don't get surrounded by monsters - that might be your death even if the monsters are not that powerful.
]]
	},
	[18] = {
		containerId = 2435,
		itemId = 2816,
		--position = (Rookgaard Libraries),
		text = [[
As we traveled through the dungeon tunnels we came to a big cave. In the light of our torches we saw several eyes glowing in the darknes, then the trolls attacked, silent as usual. We imediately dropped our torches and raised our shields to block the first attack, then we counterattacked. Soon the floor was wet with blood, ours and theirs. They were verry skilled in blocking our blows and I am sure with inferior weapons we would have hacked on this beasts for an eternity.
]]
	},
	[19] = {
		containerId = 2436,
		itemId = 2827,
		position = {x = 32069, y = 31889, z = 4},
		text = [[
As we traveled through the dungeon tunnels we came to a big cave. In the light of our torches we saw several eyes glowing in the darknes, then the trolls attacked, silent as usual. We imediately dropped our torches and raised our shields to block the first attack, then we counterattacked. Soon the floor was wet with blood, ours and theirs. They were verry skilled in blocking our blows and I am sure with inferior weapons we would have hacked on this beasts for an eternity.
		]]
	},
	[20] = {
		containerId = 2436,
		itemId = 2816,
		position = {x = 32069, y = 31889, z = 4},
		text = [[
Tactics for close-ranged combat
- Use the terrain to your advantage: always know the way to the nearest ropespot, and make sure you are not surrounded by enemies - that can be a death trap!
- Use narrow passages to make sure not more than one enemy at a time can sneak up.
- Avoid being close to more than two enemies at once if you can, because you can only block two at a time.
- Be careful while chasing an enemy: you might run into his allies or other monsters.
- Target the closest enemy, or you'll become confused and might not be able to defend yourself against other attacks.
- Different enemies require different tactics. While some are best to be fought in an agressive combat mode to finish them off quickly, you might want to defend yourself more against others. Choosing between your combat modes also depends on your equipment - play your strengths!
]]
	},
	[21] = {
		containerId = 2436,
		itemId = 2816,
		--position = (Isle of the Kings Library),
		text = [[
The Tibian Wonders of the World!
The known and acknowledged wonders of the world are:
The colossus of Kazordoon
The black pyramid of Dracoria
The great lighthouse tree of Ab'dendriel
The thorntower of Shadowthorn
The underground city of Mintwallin
The black city of skulls in Hellsgate
The great lava falls in Hellsgate
The pyramid city of Ankrahmun
		]]
	},
	[22] = {
		containerId = 2436,
		itemId = 2826,
		--position = (Ankrahmun great pyramid),
		text = [[
The Tibian Wonders of the World!
The known and acknowledged wonders of the world are:
The colossus of Kazordoon
The black pyramid of Dracoria
The great lighthouse tree of Ab'dendriel
The thorntower of Shadowthorn
The underground city of Mintwallin
The black city of skulls in Hellsgate
The great lava falls in Hellsgate
The pyramid city of Ankrahmun
		]]
	},
	[23] = {
		containerId = 2436,
		itemId = 2825,
		position = {x = 32069, y = 31889, z = 4},
		text = [[
The Tibian Wonders of the World!
The known and acknowledged wonders of the world are:
The colossus of Kazordoon
The black pyramid of Dracoria
The great lighthouse tree of Ab'dendriel
The thorntower of Shadowthorn
The underground city of Mintwallin
The black city of skulls in Hellsgate
The great lava falls in Hellsgate
The pyramid city of Ankrahmun
		]]
	},
	[24] = {
		itemId = 2831,
		position = {x = 32068, y = 31880, z = 3},
		text = [[
Genesis VII, ii. Tibia's Renewal

The humans have availed themselves well of this opportunity. Under the wise guidance of the Thaian kings, who were direct descendants of Banor, the race is living through a golden age. The arts and the sciences prosper, and many a thriving city has been founded. To be sure, the humans' expansion has met with fierce resistance, and in fact the dauntless heroes who still enter this world from the mysterious Portals of Souls are busy enough to fight the constant threat posed by all kinds of hostile creatures. But so far the peace has lasted, and under its protection the human race has finally asserted itself as the dominant species in Tibia. However, there are disquieting signs that this glorious era might slowly come to its end. For the old enemies have never been vanquished, and now it seems that they are growing increasingly restless. The fierce orcs are stirring once more, attacking human settlements and sometimes even major cities in vicious, well-coordinated attacks. The undead have again started to walk the land, striking fear into the hearts of the living. There are even disconcerting reports that the fearsome dragons who have lain dormant for centuries are again leaving their hidden lairs to prey. Worst of all, the humans, that curious race, have started bickering amongst themselves, and more than once tensions have led to armed conflicts. In the course of time, some humans even renounced the Thaian kings' rule and founded own cities and empires.

It may be that this is yet another one of Zathroth's wicked ploys. It is well known that his most diabolic minions, the gruesome demons, are lurking in the shadows, biding their time. Who knows - perhaps Tibia is on the brink of another cataclysmic war, and a new twilight will fall on the world. Fate alone knows what the future has in store for Tibia. Let us all hope and pray that the humans' unity will not break just when it is needed most.
		]]
	},
	[25] = {
		itemId = 2831,
		position = {x = 32054, y = 31894, z = 4},
		text = [[
GV.i Part 1: The Age of Chaos

Uman looked with sadness at the damage his evil half had done to the creation Fardos and he had worked for so hard. He felt that Zathroth had finally gone too far. In his desperation he turned to Fardos for advice. Together, they decided that it would be best to sever the bond between Uman and Zathroth once and for all. They set about to this task with great energy, and their efforts soon enough appeared to be crowned with success. However, the weaker the bond between Uman and Zathroth became, the weaker Uman himself grew, and in the end they realised that the duality could not be separated without endangering Uman's very existence. At last the invocation was aborted. Uman had to accept the fact that the duality between Zathroth and himself could not be broken, and that their fate and indeed their very existence were intertwined for eternity.

However, Uman's and Fardos's joint efforts did not remain entirely without consequence, for during the unsuccessful attempt to separate the double god a small part broke away from it. This tiny shard grew and expanded until it took shape and eventually became a sentient creature of its own. This was the hour Kirok the Mad was born. Owing to his peculiar ancestry this strange god has a twisted or, as some say, a schizophrenic nature. He inherited Uman's creative mind and his inquisitive nature, so that he eventually became the patron god of all those who follow the path of science and research. However, the one trait Kirok is really famous for is his twisted sense of humour. He adores bad taste and ingenious pranks, and this peculiar characteristic makes him the favourite of bards, jesters and of all other kinds of suspicious people.

While Fardos and Uman were working hard on their spell, Zathroth's minions went on to lay waste to the elder gods' precious creation, and the devastation continued without pause. It seemed as though the whole world was doomed to perish. However, some of the lesser gods who were tired of just standing by while their beloved Tibia was ravaged. They decided to put up resistance against the reckless hordes. Bastesh the Mistress of the Sea created huge, mysterious creatures that were both elegant and fierce, and she populated her beloved ocean with them to make sure Zathroth's minions would never defile its pure waters. However, there was little she could do to help her cousins who lived on the dry land. Of all her creatures the only ones to survive on land were the dextrous and venomous snakes. Crunor and Nornur, too, created creatures to fight against Brog's and Zathroth's hordes: Crunor the Lord of the Trees created fierce wolves, while Nornur equipped his beloved spiders with deadly poison to make them more powerful.
		]]
	},
	[26] = {
		containerId = 2435,
		itemId = 129,
		position = {x = 32061, y = 31894, z = 4},
		text = [[
This is written proof that Captain Plunderpurse gave away all the cursed gold to the little kiddies, bless his generous heart. No torture, extortion, cut off limbs, manipulation or embezzlement at all was involved in my testimony, I swear! And I am very thankful not to make the acquaintance of the Captain's pet sharks, lovely beasts though they are. Signed, Triomon Tangleweed, certifying notary.
		]]
	},
	[27] = {
		containerId = 2435,
		itemId = 2826,
		position = (Nagor),
		text = [[
Treasures of the Southern Isles

Quite a few pirates hoarded up treasures in the past. It is known that pirates tend to hide their treasures on deserted islands for some unknown reason. They just bury them on some remote place and then forget about them. This similarity to the behaviour of squirrels was never scientifically verified. However, since pirates love to dress lightly they also love the south. Therefore, it is only natural that they hide their treasures there. Some of the southern isles are so popular among pirates that there is hardly any free space left to bury new treasure.

If anyone ever is looking for treasures, then those isles are the best place to start with.
		]]
	},
	[28] = {
		containerId = 2435,
		itemId = 2821,
		--position = (Isle of the Kings Library),
		text = [[
Treasures of the Southern Isles

Quite a few pirates hoarded up treasures in the past. It is known that pirates tend to hide their treasures on deserted islands for some unknown reason. They just bury them on some remote place and then forget about them. This similarity to the behaviour of squirrels was never scientifically verified. However, since pirates love to dress lightly they also love the south. Therefore, it is only natural that they hide their treasures there. Some of the southern isles are so popular among pirates that there is hardly any free space left to bury new treasure.

If anyone ever is looking for treasures, then those isles are the best place to start with.
		]]
	},
	[29] = {
		containerId = 2435,
		itemId = 2827,
		position = {x = 32061, y = 31894, z = 4},
		text = [[
Treasures of the Southern Isles

Quite a few pirates hoarded up treasures in the past. It is known that pirates tend to hide their treasures on deserted islands for some unknown reason. They just bury them on some remote place and then forget about them. This similarity to the behaviour of squirrels was never scientifically verified. However, since pirates love to dress lightly they also love the south. Therefore, it is only natural that they hide their treasures there. Some of the southern isles are so popular among pirates that there is hardly any free space left to bury new treasure.

If anyone ever is looking for treasures, then those isles are the best place to start with.
		]]
	},
	[30] = {
		containerId = 2435,
		itemId = 2829,
		position = {x = 32061, y = 31894, z = 4},
		text = [[
The Great Sea Serpents

The Sea Serpent is as huge as a house and can swallow a small ship in one bite. Its scales are almost impenetrable and its teeth, which are as big as a cyclops, are coated with a corrosive poison that will dissolve human flesh on touch. In their undersea lairs they hoard treasures that would make a dragons hoard look miserable.
]]
	},
	[31] = {
		containerId = 2435,
		itemId = 2826,
		--position = (Nagor),
		text = [[
The Great Sea Serpents

The Sea Serpent is as huge as a house and can swallow a small ship in one bite. Its scales are almost impenetrable and its teeth, which are as big as a cyclops, are coated with a corrosive poison that will dissolve human flesh on touch. In their undersea lairs they hoard treasures that would make a dragons hoard look miserable.
		]]
	},
	[32] = {
		containerId = 2435,
		itemId = 2821,
		--position = (Liberty Bay freedom street),
		text = [[
The Great Sea Serpents

The Sea Serpent is as huge as a house and can swallow a small ship in one bite. Its scales are almost impenetrable and its teeth, which are as big as a cyclops, are coated with a corrosive poison that will dissolve human flesh on touch. In their undersea lairs they hoard treasures that would make a dragons hoard look miserable.
		]]
	},
	[33] = {
		containerId = 2435,
		itemId = 2816,
		--position = (Isle of the Kings Library),
		text = [[
The Great Sea Serpents

The Sea Serpent is as huge as a house and can swallow a small ship in one bite. Its scales are almost impenetrable and its teeth, which are as big as a cyclops, are coated with a corrosive poison that will dissolve human flesh on touch. In their undersea lairs they hoard treasures that would make a dragons hoard look miserable.
		]]
	},
	[34] = {
		containerId = 2435,
		itemId = 2829,
		position = (kharos),
		text = [[
The Great Sea Serpents

The Sea Serpent is as huge as a house and can swallow a small ship in one bite. Its scales are almost impenetrable and its teeth, which are as big as a cyclops, are coated with a corrosive poison that will dissolve human flesh on touch. In their undersea lairs they hoard treasures that would make a dragons hoard look miserable.
		]]
	},
	[35] = {
		containerId = 2435,
		itemId = 2831,
		position = {x = 32061, y = 31894, z = 4},
		text = [[
V.i Part 2: The Age of Chaos

However, for all their efforts, the gods could not create creatures that were a match for the ruthless, well-organised hordes that roamed the land. The wolves' hides and the spiders chitinous exoskeletons could not resist the steel of the orcish blades, and for every troll that was brought down by poison two others came to take his place. In the end gods' children withdrew to areas that were easy to defend: The wolves fled into the depths of the forests, while the spiders hid deep in caves. There they continued their fights, defending their realms against the onslaught of the superior enemy. These little pockets of resistance were the only sanctuaries in a world that sank deeper and deeper into chaos. And the worst was yet to come, for now the dragons felt the time had come to take what was theirs by right!

For centuries they had propagated and expanded in silence, largely unnoticed by all other creatures. But now that Garsharak, the very first and strongest of their race, sent them into the world they knew neither restraint nor mercy. The orcish armies were routed by the relentless flames of magical dragon fire, and soon that proud though barbaric race, who until then had not known the meaning of the word defeat, was driven into the shelter of subterranean settlements. Their allies, the mighty cyclopes, fared no better. Although they won a number of notable victories using their powerful weapons and armour, they, too, had to yield to the superior power of the dreaded dragons. They joined their former allies, the orcs, and their weak cousins, the trolls, in their subterranean exile. Their proud cities that had been built in the course of centuries were burnt down to the ground, and their renowned forges were lost forever.

Thus the dragons had taken over the rule of the land, but the war was by no means over. Their bitter enemies, cyclopes and orcs, resented what they felt was an imprisonment in the bowels of the earth, and they continued the fight from their subterranean hideouts. And in fact the dragons, who had already been weakened in the course of the previous battles, suffered serious losses. But now war also erupted among the former allies, as cyclopes and orcs competed for food and space in their subterranean abodes. And even though no side was strong enough to overcome the others the war went on with undiminished force, and all of the races suffered greatly in the epic struggle. The land was scattered with bodies, and while it seemed that life itself would be wiped from the face of Tibia the losses of all races that were involved daily grew in number. It was as if the living would drown in the bodies of the slain.
]]
	},
	[36] = {
		containerId = 2459,
		itemId = 2831,
		position = {x = 32075, y = 31894, z = 4},
		text = [[
V. ii, The Age of Chaos

The elder gods watched as the cataclysmic battle went on. They felt no pity for those that were slain because they cared little for Zathroth's creatures, but they knew that something was missing, that somebody was needed to take care of the bodies and souls of those who ceased to live. They began to look for a solution, and finally Uman proposed that a new god should be created, a god who should see to it that the dead would be taken care of. They decided that earth, which in a way was the giver of life, should have a part in taking it back, and that Uman should be the newly created god's father. But alas! The elder gods were not as cautious as they should have been, and so Zathroth the Destroyer learnt about their plans all too soon. He was fascinated by the idea of death from the start, because he saw in it a new chance to bring further havoc and destruction into the world. Soon he had devised a vicious plan. He posed as his good half Uman to fool earth, and with it he sired another god: Urgith the Master of the Undead. This hideous deity was devoted to death just like the god Uman and Fardos had in mind, but he was not the benign guardian of the dead they had envisioned. Instead, Urgith was a cruel god who strove to infuse the bodies of the dead with unholy energy, dooming them to a state that was neither life nor death. Thus, the hour of Urgith's birth marked the beginning of undeath.

Soon enough innumerable undead roamed the world. After all, Tibia was still covered by countless bodies of slain orcs, cyclopes and other creatures - the legacy of the many years of ceaseless war. These cadavers provided Urgith with the ideal recruitment pool, and he eagerly transformed all carcasses he could lay his hands into his gruesome servants. The gods watched in horror as a new scourge ravaged their beloved creation. They hurried to finally put their own initial plan into practice, and Uman united with earth in order to sire Toth the Warden of the Souls. It was to be his mission to safely guide the souls of the dead to the otherworld, where they would safely rest in the peace of an eternal dreamless slumber, while the worms, his faithful servants, swarmed out to devour their bodies that scattered the face of Tibia. But the damage had been done, and even though Toth and his servants did the best they could Urgith's ghastly creations continued to roam the land. All the other creatures, who were already greatly weakened by their endless wars, could put up little resistance to the new enemy who increased in strength with every loss they suffered. It looked as if Tibia was forever doomed to be a world that was inhabited by the living dead.

The elder gods looked at what had happened to their world, and their hearts filled with sorrow and resentment. They knew that if they did not act now Tibia would be destined to become a grave, and so they started looking for a solution. Eventually they agreed to try to create a sentient race of their own, a race that would be strong enough to take up the fight against the hordes that ravaged their beloved world. And so they created a race and sent it into Tibia. But alas! Urgith's minions were too strong. Their race was defeated within a generation, and it was wiped from the face of Tibia. So Uman and Fardos created race after race, and race after race was overwhelmed by the vicious abominations that Urgith had released into the world. Most of these races disappeared from the face of Tibia forever, leaving little but melancholy legends and mysterious ruins. Today, this sad era which is commonly known as the Corpse War is largely shrouded in mystery, and the unfortunate races that were destroyed in it are now referred to as the ancients.
		]]
	},
	[37] = {
		containerId = 2459,
		itemId = 2830,
		position = {x = 32075, y = 31894, z = 4},
		text = [[
The Shattered Isles

Nargor is a hostile rock surrounded by treacherous reefs. Since it is uninhabitable and almost unreachable it is of no interest.

Treasure Island is not only desert-like but also quite deserted. The only people you meet are treasure hunters that travel there occasionally to try their luck.

The inhabitants of the town Liberty Bay live on the numerous plantations. The town has developed into a major trading center in recent years, and is under Thaian rule.

The Forbidden Islands to the north-west are dangerous not only because of the volcanoes that are found there but also due to frequent quara activity. Since there is no real reason to visit these islands, no regular shipping route was ever established.

The Laguna Islands are quite often visited by passing ships to refresh their supply of water and food. Still the isles are too desolate to establish a settlement there. It is rumored that a small tribe of savages calls one of the isles its home.
]]
	},
	[38] = {
		containerId = 2459,
		itemId = 2825,
		position = (Nagor),
		text = [[
The Shattered Isles

Nargor is a hostile rock surrounded by treacherous reefs. Since it is uninhabitable and almost unreachable it is of no interest.

Treasure Island is not only desert-like but also quite deserted. The only people you meet are treasure hunters that travel there occasionally to try their luck.

The inhabitants of the town Liberty Bay live on the numerous plantations. The town has developed into a major trading center in recent years, and is under Thaian rule.

The Forbidden Islands to the north-west are dangerous not only because of the volcanoes that are found there but also due to frequent quara activity. Since there is no real reason to visit these islands, no regular shipping route was ever established.

The Laguna Islands are quite often visited by passing ships to refresh their supply of water and food. Still the isles are too desolate to establish a settlement there. It is rumored that a small tribe of savages calls one of the isles its home.
		]]
	},
	[39] = {
		containerId = 2459,
		itemId = 2832,
		--position = (Liberty Bay freedom street),
		text = [[
The Shattered Isles

Nargor is a hostile rock surrounded by treacherous reefs. Since it is uninhabitable and almost unreachable it is of no interest.

Treasure Island is not only desert-like but also quite deserted. The only people you meet are treasure hunters that travel there occasionally to try their luck.

The inhabitants of the town Liberty Bay live on the numerous plantations. The town has developed into a major trading center in recent years, and is under Thaian rule.

The Forbidden Islands to the north-west are dangerous not only because of the volcanoes that are found there but also due to frequent quara activity. Since there is no real reason to visit these islands, no regular shipping route was ever established.

The Laguna Islands are quite often visited by passing ships to refresh their supply of water and food. Still the isles are too desolate to establish a settlement there. It is rumored that a small tribe of savages calls one of the isles its home.
		]]
	},
	[40] = {
		containerId = 2459,
		itemId = 2839,
		--position = (Liberty Bay Malunga),
		text = [[
The Shattered Isles

Nargor is a hostile rock surrounded by treacherous reefs. Since it is uninhabitable and almost unreachable it is of no interest.

Treasure Island is not only desert-like but also quite deserted. The only people you meet are treasure hunters that travel there occasionally to try their luck.

The inhabitants of the town Liberty Bay live on the numerous plantations. The town has developed into a major trading center in recent years, and is under Thaian rule.

The Forbidden Islands to the north-west are dangerous not only because of the volcanoes that are found there but also due to frequent quara activity. Since there is no real reason to visit these islands, no regular shipping route was ever established.

The Laguna Islands are quite often visited by passing ships to refresh their supply of water and food. Still the isles are too desolate to establish a settlement there. It is rumored that a small tribe of savages calls one of the isles its home.
		]]
	},
	[41] = {
		containerId = 2459,
		itemId = 2825,
		--position = (Carlin Congress),
		text = [[
The Shattered Isles

Nargor is a hostile rock surrounded by treacherous reefs. Since it is uninhabitable and almost unreachable it is of no interest.

Treasure Island is not only desert-like but also quite deserted. The only people you meet are treasure hunters that travel there occasionally to try their luck.

The inhabitants of the town Liberty Bay live on the numerous plantations. The town has developed into a major trading center in recent years, and is under Thaian rule.

The Forbidden Islands to the north-west are dangerous not only because of the volcanoes that are found there but also due to frequent quara activity. Since there is no real reason to visit these islands, no regular shipping route was ever established.

The Laguna Islands are quite often visited by passing ships to refresh their supply of water and food. Still the isles are too desolate to establish a settlement there. It is rumored that a small tribe of savages calls one of the isles its home.
		]]
	},
	[42] = {
		containerId = 2459,
		itemId = 2821,
		--position = (Carlin Explorer Club),
		text = [[
The Shattered Isles

Nargor is a hostile rock surrounded by treacherous reefs. Since it is uninhabitable and almost unreachable it is of no interest.

Treasure Island is not only desert-like but also quite deserted. The only people you meet are treasure hunters that travel there occasionally to try their luck.

The inhabitants of the town Liberty Bay live on the numerous plantations. The town has developed into a major trading center in recent years, and is under Thaian rule.

The Forbidden Islands to the north-west are dangerous not only because of the volcanoes that are found there but also due to frequent quara activity. Since there is no real reason to visit these islands, no regular shipping route was ever established.

The Laguna Islands are quite often visited by passing ships to refresh their supply of water and food. Still the isles are too desolate to establish a settlement there. It is rumored that a small tribe of savages calls one of the isles its home.
]]
	},
	[43] = {
		containerId = 2460,
		itemId = 2832,
		position = {x = 32068, y = 31898, z = 4},
		text = [[
My travels.

As the orcs approached I've hidden myself in the bushes near the lake. I did hardly dare to breath as they met only some inches from my nose. I thought my wild beating heart might betray me to this murderous beasts. I overheared the greenskined brutes. 'charach' (or so) one said and the other responded the same way, then they began to chat in their strange language, certainly talking about some gruesome plot against mankind. Talking they wandered away and after they vanished from my view I quickly got up and headed to Thais as fast as I could.
]]
	},
	[44] = {
		containerId = 2460,
		itemId = 2821,
		--position = (Rookgaard Academy),
		text = [[
My travels.

As the orcs approached I've hidden myself in the bushes near the lake. I did hardly dare to breath as they met only some inches from my nose. I thought my wild beating heart might betray me to this murderous beasts. I overheared the greenskined brutes. 'charach' (or so) one said and the other responded the same way, then they began to chat in their strange language, certainly talking about some gruesome plot against mankind. Talking they wandered away and after they vanished from my view I quickly got up and headed to Thais as fast as I could.
		]]
	},
	[45] = {
		containerId = 2460,
		itemId = 2821,
		position = {x = 32068, y = 31898, z = 4},
		text = [[
Tibiantis: Fact and Fiction

In the light of progress made my modern science the tales of Tibiantis can be cheerfully disregarded as blatant myths. The author of this questionable history merely drew upon several myths and mixed them together to create a tale plausible to those given to believe such romantic nonsense. The recently discovered, or more accurately, recently rediscovered, city of Yalahar is very obviously a major inspiration for the story of Tibiantis. Aspects of the story can be found in actual fact in Yalahar - the city itself is huge, and also extended its borders beyond the land into the sea, and judging from what can be found there, was most definitely at some point in its past a city that was home to great wonders, whose inhabitants were in possession of great knowledge. However, one of the great mysteries of Yalahar is whether in actual fact those that live there are even human or another race, until recently unknown amongst the Tibian civilisations. The aspect of the story of Tibiantis referring to the downfall of a civilisation could be influenced by many different myths. One such source could be based upon the discoveries made far to the North of Tibia which suggest the possibility of a civilisation that was wiped out by an as yet unknown catastrophe of cataclysmic proportions. Equally, to the extreme south of Tibia can be found the Shattered Isles. These Isles were so named with good reason - geological studies conducted by the Explorers' Society reveal that these isles did not so much sink but were blasted by a phenomenal explosion of some kind. Relics found upon the Isles also hint that they were once populated by a great and most likely advanced civilisation. It is the sad fate of these isles to be the home of the infamous Quara. It is these twisted creatures who probably provide the origin of the myth's fish people. In summary, I believe I have gathered enough proof here to dispell any reason for believing the tale of Tibiantis, and have proven it to be nothing but a conglomeration of ancient stories and legends which an overly ambitious and half informed so-called historian has put together into a new myth of his own making, in order to gain cheap fame by hoodwinking a gullible and uninformed public.
]]
	},
	[46] = {
		containerId = 2460,
		itemId = 2826,
		--position = (Carlin Congress),
		text = [[
Tibiantis: Fact and Fiction

In the light of progress made my modern science the tales of Tibiantis can be cheerfully disregarded as blatant myths. The author of this questionable history merely drew upon several myths and mixed them together to create a tale plausible to those given to believe such romantic nonsense. The recently discovered, or more accurately, recently rediscovered, city of Yalahar is very obviously a major inspiration for the story of Tibiantis. Aspects of the story can be found in actual fact in Yalahar - the city itself is huge, and also extended its borders beyond the land into the sea, and judging from what can be found there, was most definitely at some point in its past a city that was home to great wonders, whose inhabitants were in possession of great knowledge. However, one of the great mysteries of Yalahar is whether in actual fact those that live there are even human or another race, until recently unknown amongst the Tibian civilisations. The aspect of the story of Tibiantis referring to the downfall of a civilisation could be influenced by many different myths. One such source could be based upon the discoveries made far to the North of Tibia which suggest the possibility of a civilisation that was wiped out by an as yet unknown catastrophe of cataclysmic proportions. Equally, to the extreme south of Tibia can be found the Shattered Isles. These Isles were so named with good reason - geological studies conducted by the Explorers' Society reveal that these isles did not so much sink but were blasted by a phenomenal explosion of some kind. Relics found upon the Isles also hint that they were once populated by a great and most likely advanced civilisation. It is the sad fate of these isles to be the home of the infamous Quara. It is these twisted creatures who probably provide the origin of the myth's fish people. In summary, I believe I have gathered enough proof here to dispell any reason for believing the tale of Tibiantis, and have proven it to be nothing but a conglomeration of ancient stories and legends which an overly ambitious and half informed so-called historian has put together into a new myth of his own making, in order to gain cheap fame by hoodwinking a gullible and uninformed public.
		]]
	},
	[47] = {
		containerId = 2460,
		itemId = 2824,
		--position = (Isle of the Kings Library),
		text = [[
Tibiantis: Fact and Fiction

In the light of progress made my modern science the tales of Tibiantis can be cheerfully disregarded as blatant myths. The author of this questionable history merely drew upon several myths and mixed them together to create a tale plausible to those given to believe such romantic nonsense. The recently discovered, or more accurately, recently rediscovered, city of Yalahar is very obviously a major inspiration for the story of Tibiantis. Aspects of the story can be found in actual fact in Yalahar - the city itself is huge, and also extended its borders beyond the land into the sea, and judging from what can be found there, was most definitely at some point in its past a city that was home to great wonders, whose inhabitants were in possession of great knowledge. However, one of the great mysteries of Yalahar is whether in actual fact those that live there are even human or another race, until recently unknown amongst the Tibian civilisations. The aspect of the story of Tibiantis referring to the downfall of a civilisation could be influenced by many different myths. One such source could be based upon the discoveries made far to the North of Tibia which suggest the possibility of a civilisation that was wiped out by an as yet unknown catastrophe of cataclysmic proportions. Equally, to the extreme south of Tibia can be found the Shattered Isles. These Isles were so named with good reason - geological studies conducted by the Explorers' Society reveal that these isles did not so much sink but were blasted by a phenomenal explosion of some kind. Relics found upon the Isles also hint that they were once populated by a great and most likely advanced civilisation. It is the sad fate of these isles to be the home of the infamous Quara. It is these twisted creatures who probably provide the origin of the myth's fish people. In summary, I believe I have gathered enough proof here to dispell any reason for believing the tale of Tibiantis, and have proven it to be nothing but a conglomeration of ancient stories and legends which an overly ambitious and half informed so-called historian has put together into a new myth of his own making, in order to gain cheap fame by hoodwinking a gullible and uninformed public.
		]]
	},
	[48] = {
		containerId = 2460,
		itemId = 2831,
		position = {x = 32068, y = 31898, z = 4},
		text = [[
You can not even imagine how old I am. In your wildest dreams you won't see the things I have seen. I am the last of my race and even though I am several centuries old I am not immortal and will eventually die. I fear that day. Not for me - I am weary and I don't care much about if I'm alive or dead. But I fear for all these memories that will die with me. For all those who no one will remember anymore.
Words can't truly preserve their essence so I will leave no books or stone tablets. If I die, everything I have witnessed will die with me as if it has never existed. I was there when Rorak slew Tingil at the stairs of the seven temples. I was there as Riik led his peaceloving people to the far north to find refuge from the war. I was there to witness the betrayal of Asric for the whims of a female that was long dead by then. I fought with the last Frdai a futile battle on the plains of Weskurt against the unseen legion. I witnessed Ss'rar making his move on ascension to become the serpent god. I watched the first elves struggling to form a nation with the help of the lightbearers. It was me who assisted the great calculator to assemble the bonelords language. And you come here to this mountain and ask me how to win the heart of some shepherdess? This world has become a ridiculous mockery.
]]
	},
	[49] = {
		containerId = 2460,
		itemId = 2816,
		--position = (Isle of the Kings Library),
		text = [[
You can not even imagine how old I am. In your wildest dreams you won't see the things I have seen. I am the last of my race and even though I am several centuries old I am not immortal and will eventually die. I fear that day. Not for me - I am weary and I don't care much about if I'm alive or dead. But I fear for all these memories that will die with me. For all those who no one will remember anymore.
Words can't truly preserve their essence so I will leave no books or stone tablets. If I die, everything I have witnessed will die with me as if it has never existed. I was there when Rorak slew Tingil at the stairs of the seven temples. I was there as Riik led his peaceloving people to the far north to find refuge from the war. I was there to witness the betrayal of Asric for the whims of a female that was long dead by then. I fought with the last Frdai a futile battle on the plains of Weskurt against the unseen legion. I witnessed Ss'rar making his move on ascension to become the serpent god. I watched the first elves struggling to form a nation with the help of the lightbearers. It was me who assisted the great calculator to assemble the bonelords language. And you come here to this mountain and ask me how to win the heart of some shepherdess? This world has become a ridiculous mockery.
		]]
	},
	[50] = {
		containerId = 2460,
		itemId = 2829,
		position = {x = 32068, y = 31898, z = 4},
		text = [[
The Lighthouse in the Middle of Nowhere
Sailors claim to have travelled as far as the end of the world where the water pours down into nothingness. Although it is easily recognizable during daylight it poses a special threat at night. To make matters worse, a spooky lighthouse sometimes appears out of nowhere to lure ships over the edge of the world. Whether it is really a lighthouse or some other source of light differs from story to story and remains to be determined.
]]
	},
	[51] = {
		containerId = 2460,
		itemId = 2827,
		--position = (Liberty Bay),
		text = [[
The Lighthouse in the Middle of Nowhere
Sailors claim to have travelled as far as the end of the world where the water pours down into nothingness. Although it is easily recognizable during daylight it poses a special threat at night. To make matters worse, a spooky lighthouse sometimes appears out of nowhere to lure ships over the edge of the world. Whether it is really a lighthouse or some other source of light differs from story to story and remains to be determined.
		]]
	},
	[52] = {
		itemId = 11441,
		position = {x = 32075, y = 31898, z = 4},
		text = "Personal log book of Mr Morris. (The following lines are written in a code that you cannot make out. It seems Mr Morris is a very distrustful person.)"
	},
	[53] = {
		itemId = 2824,
		position = {x = 32070, y = 31900, z = 4},
		text = [[
The .........
Some of he ancients formed .......amlands. They build mighty fortresses to ........................, conscious or not. It was then, when the mysteri............... and his anger shook the foundation of .....................................awakened screaming in fear and pain. And after the ................................................................................ were gone! All of them with all ..........................................................ost their best men in theese days and never recovered from the ........................................... for the other ancients and so the time of the first dreammasters ended.
From this time on ............. manipulate little of the matter of the dreamlands to ................................................. others in their .................... and prophecy, but not to ..........
]]
	},
	[54] = {
		containerId = 2460,
		itemId = 2816,
		--position = (Isle of the Kings Library),
		text = [[
The .........
Some of he ancients formed .......amlands. They build mighty fortresses to ........................, conscious or not. It was then, when the mysteri............... and his anger shook the foundation of .....................................awakened screaming in fear and pain. And after the ................................................................................ were gone! All of them with all ..........................................................ost their best men in theese days and never recovered from the ........................................... for the other ancients and so the time of the first dreammasters ended.
From this time on ............. manipulate little of the matter of the dreamlands to ................................................. others in their .................... and prophecy, but not to ..........
		]]
	},
	[55] = {
		itemId = 639,
		position = {x = 32070, y = 31900, z = 4},
		text = [[
(It is covered with a strange language that you cannot make out.)
		]]
	},
	[56] = {
		itemId = 2832,
		position = {x = 32052, y = 31898, z = 6},
		text = [[
...

The elder gods looked at what had happened to their world, and their hearts filled with sorrow and resentment. They knew that if they did not act now Tibia would be destined to become a grave, and so they started looking for a solution. Eventually they agreed to try to create a sentient race of their own, a race that would be strong enough to take up the fight against the hordes that ravaged their beloved world. And so they created a race and sent it into Tibia. But alas! Urgith's minions were too strong. Their race was defeated within a generation, and it was wiped from the face of Tibia. So Uman and Fardos created race after race, and race after race was overwhelmed by the vicious abominations that Urgith had released into the world. Most of these races disappeared from the face of Tibia forever, leaving little but melancholy legends and mysterious ruins. Today, this sad era which is commonly known as the Corpse War is largely shrouded in mystery, and the unfortunate races that were destroyed in it are now referred to as the Ancients.

...
		]]
	},
	[57] = {
		containerId = 2460,
		itemId = 2829,
		position = {x = 32052, y = 31896, z = 6},
		text = "Cooking Recipes for the Wildlife (excepting Squirrels!), by Richard"
	},
	[58] = {
		containerId = 2460,
		itemId = 2831,
		position = {x = 32052, y = 31896, z = 6},
		text = [[
V. iii, The Age of Chaos

However, not all of the ancients were eradicated in the fierce struggle. At least two of the races created by the elder gods in the course of this epic struggle somehow managed to escape destruction and to survive until today. One of them was the elves, delicate creatures who could handle bows and musical instruments with equal skill. The other was the dwarfs, a stout race of gifted miners and smiths. Both of these races fought bravely, but both of them had to yield to the vicious power of their enemies, and it was only by fleeing into safe places of refuge that they managed to survive. The elves after many hardships sought shelter in the unfathomable depths of the forests, while the dwarfs barricaded themselves in their impenetrable fortresses deep in Tibia's mountains. There, these races waited for better times, bitterly deploring the cruel fate that had sent them into this dreadful world. But at least they had survived. All the other ancient races were seemingly sentenced to oblivion, although it is occasionally claimed that there are other survivors.

For all their strength, these races had one important flaw in common: They lacked flexibility. And this proved to be fatal in the war against the relentless enemy they were facing. Those who were not annihilated succumbed to Zathroth's temptations. More than one of the ancients fell for Zathroth's cunning promises of power and knowledge, and legend has it that the wrathful elder gods brutally punished many of them for their treachery. There is even a persistent theory that some of these ancients later on were formed by the devious Zathroth into the very first demons. Be that as it may, all the ancients failed to live up to their creators' expectations: One by one they were overwhelmed by the enemy, and still the hordes walked the world. But the elder gods had learnt from their mistakes. Their next creation was to be well suited for the task. And they called them the humans.
		]]
	},
	[59] = {
		containerId = 2460,
		itemId = 2827,
		position = {x = 32052, y = 31896, z = 6},
		text = [[
Thoughts and Notations on the Noble Craft of Potion-Making, by Grandsieur Haruvan of Drefia (the way of writing and the pages look very, very old)

The Gods gave their gifts freely, but bestowed them not on all creatures alike. Some ancient creatures were possessed of a far-reaching will to conquer and subdue all others through their thoughts alone, while the newer beings could weave magic in defense or had strength and swiftness to defend and escape the wiles laid out to ensnare them. Some animals and plants, simple though they may seem to us, yet are deadly poisonous in order to ward off their hunter.


But only the more intelligent beings - and of those, only a select few - possess the art of making powerful concoctions that enhance their faculties.
The humble woodman or wanderer will never be able to fulfil the complex rites, or even grasp the concept, of the trimagical umbralistic principle of the equinox formula that is crucial to the craft of magical potions.
But still, they can drink, and appreciate, the brews we make to keep a warrior's body alive in a fight, the mage's mana when drained, the paladin's spirit when they need to gather holy force. ... (you lose interest and close the book)
		]]
	},
	[60] = {
	-- Hiding the Amulet (Dawnport quest)
		itemId = 21393,
		position = {x = 32046, y = 31915, z = 7},
		text = [[
(You can barely read the following words on this soiled piece of paper)

... growing weaker by the minute. I should have... bad feeling about this!
The cyclops ...
... too many of them. No help. I must...
... hid the ancient amulet beneath the sand, before ...should have listened to ...
Must hide... paper, hope an adventurer will...


... amulet will be washed ashore if not found...
To any adventurer friend: ... shovel... beach...
.. dig there. ... take it to Morris, maybe he ... decipher the engravings.

Signed
Dormovo the Impetuous
		]]
	},
	[61] = {
		itemId = 2819,
		position = {x = 32854, y = 31992, z = 11},
		text = [[
What I thought to be digging men are in fact strange green creatures with many arms or eyestalks, who can dig very fast. I think they are called "Beholders".
They did not attack me yet, although I am sure they can sense me. Who knows, maybe they have no interest in me, and I can use their tunnels to get out of here? I will not attack them, unless I have to defend myself.
I stopped counting the days, because I lost all feeling for time down here.

Oh, how I long to see humans again!]]
	},
	[62] = {
		itemId = 2819,
		position = {x = 33063, y = 31624, z = 15},
		text = "Buried forever that he never shall return. Don't remove this seal or bad things may happen."
	}
}

SignTable = {
	[1] = {
		itemId = 2012,
		itemPos = {x = 32073, y = 31936, z = 7},
		text = "No come near! Goblin home! Humans leave!"
	},
	[2] = {
		itemId = 8007,
		itemPos = {x = 32053, y = 31886, z = 6},
		text = "Sorcerers of Tibia, use the power of the elements to hunt down your foes and strike \z
		fear in the heart of your enemies!"
	},
	[3] = {
		itemId = 2104,
		itemPos = {x = 32061, y = 31886, z = 6},
		text = "Paladins of Tibia, arm yourselves and deal merciless death to all that is evil!"
	},
	[4] = {
		itemId = 8008,
		itemPos = {x = 32067, y = 31886, z = 6},
		text = "Knights of Tibia, gird yourselves to combat evil and to protect the innocent!"
	},
	[5] = {
		itemId = 7592,
		itemPos = {x = 32075, y = 31886, z = 6},
		text = "Druids of Tibia, take up your rod to hunt down evil and heal the wounds of the world!"
	},
	[6] = {
		itemId = 2597,
		itemPos = {x = 32056, y = 31890, z = 6},
		text = "Alchemical fluid generator machine. Caution - random effects!"
	},
	[7] = {
		itemId = 2031,
		itemPos = {x = 32064, y = 31891, z = 6},
		text = "Rise, Heroes!"
	},
	[8] = {
		itemId = 2602,
		itemPos = {x = 32057, y = 31893, z = 6},
		text = "Careful with the dustbin! Every item you throw into it will be PERMANENTLY deleted. \z
		So consider carefully if you really, really want to delete an item before you lay it on the dustbin."
	},
	[9] = {
		itemId = 2024,
		itemPos = {x = 32062, y = 31894, z = 3},
		text = "Southern Trade Room"
	},
	[10] = {
		itemId = 1982,
		itemPos = {x = 32566, y = 31964, z = 1},
		text = [[
No treasures here you fools!
Leave the grave of my master alone or feel my wrath!
		]]
	},
	[11] = {
		itemId = 134,
		itemPos = {x = 32566, y = 31963, z = 1},
		text = [[
In memory of my beloved master.
One day you will see from your place in heaven that I was right. I AM NOT MAD!
And it was not my fault! 
It's your own fault that you are dead now. 
Not mine!
		]]
	},
	[12] = {
		itemId = 2012,
		itemPos = {x = 32477, y = 31904, z = 4},
		text = "Room of Sacrifice"
	},
	[13] = {
		itemId = 2027,
		itemPos = {x = 32476, y = 31900, z = 3},
		text = "Cedric, the white knight"
	},
	[14] = {
		itemId = 2027,
		itemPos = {x = 32481, y = 31900, z = 3},
		text = "Tristan, the black knight"
	},
	[15] = {
		itemId = 2012,
		itemPos = {x = 33044, y = 32067, z = 12},
		text = "DO NOT ENTER!"
	},
	[16] = {
		itemId = 12783,
		itemPos = {x = 32205, y = 32883, z = 7},
		text = "DANGER. Quara sighted below. Experienced adventurers only! Do not swim into a water channel unless you are prepared to meet your death!"
	}
}
